# Sid Meier's Civilization 4
# Copyright Firaxis Games 2005

#
# Sevopedia 2.3
#   sevotastic.blogspot.com
#   sevotastic@yahoo.com
#
# additional work by Gaurav, Progor, Ket, Vovan, Fitchn, LunarMongoose
# see ReadMe for details
#

from CvPythonExtensions import *
import CvUtil
import ScreenInput
import SevoScreenEnums

gc = CyGlobalContext()
ArtFileMgr = CyArtFileMgr()
localText = CyTranslator()

class SevoPediaCivilization:

	def __init__(self, main):
		self.iCivilization = -1
		self.top = main

		self.X_MAIN_PANE = self.top.X_PEDIA_PAGE
		self.Y_MAIN_PANE = self.top.Y_PEDIA_PAGE

		self.Y_LEADER = self.Y_MAIN_PANE
		self.H_LEADER = 116

		self.X_UNIT = self.X_MAIN_PANE
		self.Y_UNIT = self.Y_LEADER + self.H_LEADER + 10
		self.W_UNIT = (self.top.R_PEDIA_PAGE - self.X_MAIN_PANE) * 2 / 3 - 5
		self.H_UNIT = 116

		self.X_BUILDING = self.X_UNIT + self.W_UNIT + 10
		self.Y_BUILDING = self.Y_UNIT
		self.W_BUILDING = (self.top.R_PEDIA_PAGE - self.X_MAIN_PANE) / 3 - 5
		self.H_BUILDING = 116

		self.Y_TECH = self.Y_BUILDING + self.H_BUILDING + 10
		self.H_TECH = 116

		self.H_MAIN_PANE = 116
		self.W_MAIN_PANE = 116

		self.X_TECH = self.top.X_PEDIA_PAGE
		self.W_TECH = self.top.R_PEDIA_PAGE - self.X_MAIN_PANE

		self.X_LEADER = self.X_MAIN_PANE + self.W_MAIN_PANE + 10
		self.W_LEADER = self.top.R_PEDIA_PAGE - self.X_LEADER

		self.W_ICON = 100
		self.H_ICON = 100
		self.X_ICON = self.X_MAIN_PANE + (self.H_MAIN_PANE - self.H_ICON) / 2
		self.Y_ICON = self.Y_MAIN_PANE + (self.H_MAIN_PANE - self.H_ICON) / 2
		self.ICON_SIZE = 64

		self.X_TEXT = self.X_MAIN_PANE
		self.Y_TEXT = self.Y_TECH + self.H_TECH + 10
		self.W_TEXT = self.top.R_PEDIA_PAGE - self.X_TEXT
		self.H_TEXT = self.top.B_PEDIA_PAGE - self.Y_TEXT



	def interfaceScreen(self, iCivilization):
		self.iCivilization = iCivilization
		screen = self.top.getScreen()

		screen.addPanel(self.top.getNextWidgetName(), "", "", False, False, self.X_MAIN_PANE, self.Y_MAIN_PANE, self.W_MAIN_PANE, self.H_MAIN_PANE, PanelStyles.PANEL_STYLE_BLUE50)
		screen.addPanel(self.top.getNextWidgetName(), "", "", False, False, self.X_ICON, self.Y_ICON, self.W_ICON, self.H_ICON, PanelStyles.PANEL_STYLE_MAIN)
		screen.addDDSGFC(self.top.getNextWidgetName(), ArtFileMgr.getCivilizationArtInfo(gc.getCivilizationInfo(self.iCivilization).getArtDefineTag()).getButton(), self.X_ICON + self.W_ICON/2 - self.ICON_SIZE/2, self.Y_ICON + self.H_ICON/2 - self.ICON_SIZE/2, self.ICON_SIZE, self.ICON_SIZE, WidgetTypes.WIDGET_GENERAL, -1, -1)

		self.placeTech()
		self.placeBuilding()
		self.placeUnit()
		self.placeLeader()
		self.placeText()



	def placeTech(self):
		screen = self.top.getScreen()
		panelName = self.top.getNextWidgetName()
		screen.addPanel(panelName, localText.getText("TXT_KEY_FREE_TECHS", ()), "", False, True, self.X_TECH, self.Y_TECH, self.W_TECH, self.H_TECH, PanelStyles.PANEL_STYLE_BLUE50)
		screen.attachLabel(panelName, "", "  ")
		for iTech in range(gc.getNumTechInfos()):
			if (gc.getCivilizationInfo(self.iCivilization).isCivilizationFreeTechs(iTech)):
				screen.attachImageButton(panelName, "", gc.getTechInfo(iTech).getButton(), GenericButtonSizes.BUTTON_SIZE_CUSTOM, WidgetTypes.WIDGET_PEDIA_JUMP_TO_TECH, iTech, 1, False)



	def placeBuilding(self):
		screen = self.top.getScreen()
		panelName = self.top.getNextWidgetName()
		screen.addPanel(panelName, localText.getText("TXT_KEY_UNIQUE_BUILDINGS", ()), "", False, True, self.X_BUILDING, self.Y_BUILDING, self.W_BUILDING, self.H_BUILDING, PanelStyles.PANEL_STYLE_BLUE50)
		screen.attachLabel(panelName, "", "  ")
		for iBuilding in range(gc.getNumBuildingClassInfos()):
			iUniqueBuilding = gc.getCivilizationInfo(self.iCivilization).getCivilizationBuildings(iBuilding)
			iDefaultBuilding = gc.getBuildingClassInfo(iBuilding).getDefaultBuildingIndex()
			if (iDefaultBuilding > -1 and iUniqueBuilding > -1 and iDefaultBuilding != iUniqueBuilding):
				screen.attachImageButton(panelName, "", gc.getBuildingInfo(iUniqueBuilding).getButton(), GenericButtonSizes.BUTTON_SIZE_CUSTOM, WidgetTypes.WIDGET_PEDIA_JUMP_TO_BUILDING, iUniqueBuilding, 1, False)



	def placeUnit(self):
		screen = self.top.getScreen()
		panelName = self.top.getNextWidgetName()
		screen.addPanel(panelName, localText.getText("TXT_KEY_FREE_UNITS", ()), "", False, True, self.X_UNIT, self.Y_UNIT, self.W_UNIT, self.H_UNIT, PanelStyles.PANEL_STYLE_BLUE50)
		screen.attachLabel(panelName, "", "  ")
		
		# 6.3 C - Sortierung
		for iBlub in range(gc.getNumCivilizationInfos()):
		
			iValue1 = 0
			iValue2 = 0
			iValue3 = 0
			iUniqueUnit1 = 0
			iUniqueUnit2 = 0
			iUniqueUnit3 = 0
		
			for iUnit in range(gc.getNumUnitClassInfos()):
			
				iUniqueUnit = gc.getCivilizationInfo(self.iCivilization).getCivilizationUnits(iUnit)
				iDefaultUnit = gc.getUnitClassInfo(iUnit).getDefaultUnitIndex()
				if (iDefaultUnit > -1 and iUniqueUnit > -1 and iDefaultUnit != iUniqueUnit) and self.iCivilization == iBlub:
				
					# 6.3 C - Sortierung
					# screen.attachImageButton(panelName, "", gc.getUnitInfo(iUniqueUnit).getButton(), GenericButtonSizes.BUTTON_SIZE_CUSTOM, WidgetTypes.WIDGET_PEDIA_JUMP_TO_UNIT, iUniqueUnit, 1, False)

					iPrereqTechCost = 1
					
					iPrereqTech = gc.getUnitInfo(iUniqueUnit).getPrereqAndTech()
					if iPrereqTech >= 0:
						iPrereqTechCost += (gc.getTechInfo(iPrereqTech).getResearchCost() * (gc.getTechInfo(iPrereqTech).getEra() + 2))
						if gc.getTechInfo(iPrereqTech).getEra() >= 4:
							iPrereqTechCost *= 3;
					
					for k in xrange(gc.getNUM_UNIT_AND_TECH_PREREQS()):
						iPrereqAndTech = gc.getUnitInfo(iUniqueUnit).getPrereqAndTechs(k)
						if iPrereqAndTech >= 0:
							iPrereqTechCost += gc.getTechInfo(iPrereqAndTech).getResearchCost()
					
					iValue = iPrereqTechCost

					if gc.getUnitInfo(iUniqueUnit).getBaseMoves() > 3:
						iValue *= 3;
						iValue /= 2;
					iValue += (gc.getUnitInfo(iUniqueUnit).getProductionCost() * 10)
					iValue += max(0, (gc.getUnitInfo(iUniqueUnit).getCombat() * 8))
					
					if gc.getUnitInfo(iUniqueUnit).getCombat() < 1 and gc.getUnitInfo(iUniqueUnit).getAirCombat() < 1:
						iValue = 2
					
					if iValue1 != iValue3:
					
						if iValue > iValue1:
							iValue2 = iValue1
							iUniqueUnit2 = iUniqueUnit1
							iValue1 = iValue
							iUniqueUnit1 = iUniqueUnit
					
						elif iValue < iValue3:
							iValue2 = iValue3
							iUniqueUnit2 = iUniqueUnit3
							iValue3 = iValue
							iUniqueUnit3 = iUniqueUnit
					
						else:
							iValue2 = iValue
							iUniqueUnit2 = iUniqueUnit
						
					else:
					
						if iValue1 == 0:
							iValue1 = iValue
							iUniqueUnit1 = iUniqueUnit
							iValue2 = iValue
							iUniqueUnit2 = iUniqueUnit
							iValue3 = iValue
							iUniqueUnit3 = iUniqueUnit
						
						elif iValue <= iValue3:
							iValue3 = iValue
							iUniqueUnit3 = iUniqueUnit
							
						elif iValue > iValue1:
							iValue1 = iValue
							iUniqueUnit1 = iUniqueUnit
						
			if iUniqueUnit1 != iUniqueUnit2 and iUniqueUnit1 != iUniqueUnit3 and iUniqueUnit2 != iUniqueUnit3:
				screen.attachImageButton(panelName, "", gc.getUnitInfo(iUniqueUnit3).getButton(), GenericButtonSizes.BUTTON_SIZE_CUSTOM, WidgetTypes.WIDGET_PEDIA_JUMP_TO_UNIT, iUniqueUnit3, 1, False)
				screen.attachImageButton(panelName, "", gc.getUnitInfo(iUniqueUnit2).getButton(), GenericButtonSizes.BUTTON_SIZE_CUSTOM, WidgetTypes.WIDGET_PEDIA_JUMP_TO_UNIT, iUniqueUnit2, 1, False)
				screen.attachImageButton(panelName, "", gc.getUnitInfo(iUniqueUnit1).getButton(), GenericButtonSizes.BUTTON_SIZE_CUSTOM, WidgetTypes.WIDGET_PEDIA_JUMP_TO_UNIT, iUniqueUnit1, 1, False)


	def placeLeader(self):
		screen = self.top.getScreen()
		panelName = self.top.getNextWidgetName()
		screen.addPanel(panelName, localText.getText("TXT_KEY_CONCEPT_LEADERS", ()), "", False, True, self.X_LEADER, self.Y_LEADER, self.W_LEADER, self.H_LEADER, PanelStyles.PANEL_STYLE_BLUE50)
		screen.attachLabel(panelName, "", "  ")
		for iLeader in range(gc.getNumLeaderHeadInfos()):
			civ = gc.getCivilizationInfo(self.iCivilization)
			if civ.isLeaders(iLeader):
				screen.attachImageButton(panelName, "", gc.getLeaderHeadInfo(iLeader).getButton(), GenericButtonSizes.BUTTON_SIZE_CUSTOM, WidgetTypes.WIDGET_PEDIA_JUMP_TO_LEADER, iLeader, self.iCivilization, False)



	def placeText(self):
		screen = self.top.getScreen()
		panelName = self.top.getNextWidgetName()
		screen.addPanel(panelName, "", "", True, True, self.X_TEXT, self.Y_TEXT, self.W_TEXT, self.H_TEXT, PanelStyles.PANEL_STYLE_BLUE50)
		szText = gc.getCivilizationInfo(self.iCivilization).getCivilopedia()
		screen.attachMultilineText(panelName, "Text", u"<font=2>" + szText + u"</font>", WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_LEFT_JUSTIFY)



	def handleInput (self, inputClass):
		return 0
